/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.scatter2DChartSettings;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xdat.chart.ScatterChart2D;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.gui.dialogs.ScatterChart2DSettingsDialog;
import org.xdat.gui.frames.ChartFrame;

public class Scatter2DChartDisplaySettingsActionListener
implements ActionListener,
ChangeListener {
    static final boolean printLog = false;
    private ScatterChart2D chart;
    private ChartFrame frame;
    private ScatterChart2DSettingsDialog dialog;

    public Scatter2DChartDisplaySettingsActionListener(ChartFrame chartFrame, ScatterChart2D chart, ScatterChart2DSettingsDialog dialog) {
        this.frame = chartFrame;
        this.chart = chart;
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Display all designs")) {
            this.chart.getScatterPlot2D().setDisplayedDesignSelectionMode(0);
        } else if (actionCommand.equals("Display selected designs")) {
            this.chart.getScatterPlot2D().setDisplayedDesignSelectionMode(1);
        } else if (actionCommand.equals("Display designs visible in parallel chart: ")) {
            this.chart.getScatterPlot2D().setDisplayedDesignSelectionMode(2);
        } else if (actionCommand.equals("Foreground Color")) {
            Color newColor = JColorChooser.showDialog(this.dialog, e.getActionCommand(), this.chart.getScatterPlot2D().getDecorationsColor());
            if (newColor != null) {
                this.chart.getScatterPlot2D().setDecorationsColor(newColor);
            }
            this.dialog.getFgColorButton().setCurrentColor(this.chart.getScatterPlot2D().getDecorationsColor());
        } else if (actionCommand.equals("Background Color")) {
            Color newColor = JColorChooser.showDialog(this.dialog, e.getActionCommand(), this.chart.getScatterPlot2D().getBackGroundColor());
            if (newColor != null) {
                this.chart.getScatterPlot2D().setBackGroundColor(newColor);
            }
            this.dialog.getBgColorButton().setCurrentColor(this.chart.getScatterPlot2D().getBackGroundColor());
        } else if (actionCommand.equals("Active Design Color")) {
            Color newColor = JColorChooser.showDialog(this.dialog, e.getActionCommand(), this.chart.getScatterPlot2D().getActiveDesignColor());
            if (newColor != null) {
                this.chart.getScatterPlot2D().setActiveDesignColor(newColor);
            }
            this.dialog.getStandardDesignColorButton().setCurrentColor(this.chart.getScatterPlot2D().getActiveDesignColor());
        } else if (actionCommand.equals("Selected Design Color")) {
            Color newColor = JColorChooser.showDialog(this.dialog, e.getActionCommand(), this.chart.getScatterPlot2D().getSelectedDesignColor());
            if (newColor != null) {
                this.chart.getScatterPlot2D().setSelectedDesignColor(newColor);
            }
            this.dialog.getSelectedDesignColorButton().setCurrentColor(this.chart.getScatterPlot2D().getSelectedDesignColor());
        } else if (actionCommand.equals("Set current settings as default")) {
            this.chart.setCurrentSettingsAsDefault();
        } else if (actionCommand.equals("Load default settings")) {
            this.chart.resetDisplaySettingsToDefault();
            this.frame.repaint();
            this.dialog.buildPanel(this.frame.getMainWindow(), this.frame, this.chart);
        } else {
            System.out.println("Scatter2DChartDisplaySettingsActionListener: " + e.getActionCommand());
        }
        this.frame.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = Integer.parseInt(((JSpinner)e.getSource()).getValue().toString());
        String source = ((JSpinner)e.getSource()).getName();
        ScatterPlot2D plot = this.chart.getScatterPlot2D();
        if (source.equals("dataPointSizeSpinner")) {
            plot.setDotRadius(value);
        } else {
            System.out.println("Scatter2DChartDisplaySettingsChangeListener: value: " + value);
            System.out.println("Scatter2DChartDisplaySettingsChangeListener: source: " + source);
        }
        this.frame.repaint();
    }

    private void log(String message) {
    }
}

