/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.data;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xdat.UserPreferences;
import org.xdat.data.ClusterListener;

public class Cluster
implements Serializable {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private String name;
    private Color activeDesignColor;
    private Color activeDesignColorNoAlpha;
    private boolean active = true;
    private int lineThickness = 1;
    private int uniqueIdentificationNumber;
    private transient List<ClusterListener> clusterListeners;

    public Cluster(String name, int uniqueIdentificationNumber) {
        this.log("constructor called.");
        this.name = name;
        this.uniqueIdentificationNumber = uniqueIdentificationNumber;
        this.activeDesignColor = UserPreferences.getInstance().getParallelCoordinatesActiveDesignDefaultColor();
        this.activeDesignColorNoAlpha = new Color(this.activeDesignColor.getRed(), this.activeDesignColor.getGreen(), this.activeDesignColor.getBlue());
        this.clusterListeners = new ArrayList<ClusterListener>();
    }

    private void log(String message) {
    }

    public Color getActiveDesignColor(boolean useAlpha) {
        return useAlpha ? this.activeDesignColor : this.activeDesignColorNoAlpha;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
        this.activeDesignColorNoAlpha = new Color(this.activeDesignColor.getRed(), this.activeDesignColor.getGreen(), this.activeDesignColor.getBlue());
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.lineThickness = lineThickness;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyClusterListenersOfNewName(name);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Cluster duplicate() {
        Cluster duplication = new Cluster(this.name, this.uniqueIdentificationNumber);
        duplication.setActive(this.active);
        duplication.setActiveDesignColor(this.activeDesignColor);
        duplication.setLineThickness(this.lineThickness);
        return duplication;
    }

    public void copySettingsTo(Cluster cluster) {
        cluster.setName(this.name);
        cluster.setActive(this.active);
        cluster.setActiveDesignColor(this.activeDesignColor);
        cluster.setLineThickness(this.lineThickness);
    }

    public int getUniqueIdentificationNumber() {
        return this.uniqueIdentificationNumber;
    }

    public void addClusterListener(ClusterListener l) {
        if (this.clusterListeners == null) {
            this.clusterListeners = new ArrayList<ClusterListener>();
        }
        this.clusterListeners.add(l);
    }

    public void removeClusterListener(ClusterListener l) {
        if (this.clusterListeners == null) {
            return;
        }
        if (this.clusterListeners.contains(l)) {
            this.clusterListeners.remove(l);
        }
    }

    public void notifyClusterListenersOfNewName(String newName) {
        for (ClusterListener l : this.clusterListeners) {
            l.onNameChanged(this, newName);
        }
    }
}

