/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.GridLayout;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.xdat.Main;
import org.xdat.data.DataSheet;
import org.xdat.gui.tables.DataSheetTableColumnModel;
import org.xdat.gui.tables.DataTable;
import org.xdat.gui.tables.DataTableCellEditor;
import org.xdat.gui.tables.DataTableSelectionModel;

public class DataSheetTablePanel
extends JPanel {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;
    private DataTable dataTable;

    public DataSheetTablePanel(Main mainWindow) {
        this.mainWindow = mainWindow;
        this.log("constructor called");
        this.setLayout(new GridLayout(1, 1));
        this.initialiseDataSheetTableModel();
    }

    public void initialiseDataSheetTableModel() {
        DataSheet dataSheet = this.mainWindow.getCurrentSession().getCurrentDataSheet();
        if (dataSheet != null) {
            this.removeAll();
            DataSheetTableColumnModel cm = new DataSheetTableColumnModel(this.mainWindow, dataSheet);
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
            cellRenderer.setHorizontalAlignment(0);
            DataTableCellEditor cellEditor = new DataTableCellEditor();
            TableColumn idCol = new TableColumn(0, 30, cellRenderer, cellEditor);
            idCol.setHeaderValue("#");
            idCol.setResizable(true);
            cm.addColumn(idCol);
            TableColumn[] cols = new TableColumn[dataSheet.getParameterCount() + 1];
            int colIndex = 1;
            while (colIndex <= dataSheet.getParameterCount()) {
                cols[colIndex] = new TableColumn(colIndex, 100, cellRenderer, cellEditor);
                cols[colIndex].setHeaderValue(dataSheet.getParameterName(colIndex - 1));
                cols[colIndex].setResizable(true);
                cm.addColumn(cols[colIndex]);
                ++colIndex;
            }
            this.dataTable = new DataTable(dataSheet, (TableColumnModel)cm, this.mainWindow);
            this.dataTable.setAutoResizeMode(0);
            this.dataTable.setShowGrid(true);
            this.dataTable.setColumnSelectionAllowed(false);
            this.dataTable.setRowSelectionAllowed(true);
            this.dataTable.getSelectionModel().addListSelectionListener(new DataTableSelectionModel(this.mainWindow));
            JScrollPane scrollPane = new JScrollPane(this.dataTable);
            this.setLayout(new GridLayout(1, 1));
            this.add(scrollPane);
        }
    }

    public void updateRunsTableModel() {
        DataSheet dataSheet = this.mainWindow.getCurrentSession().getCurrentDataSheet();
        if (dataSheet != null) {
            DataSheetTableColumnModel cm = new DataSheetTableColumnModel(this.mainWindow, dataSheet);
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
            cellRenderer.setHorizontalAlignment(0);
            TableColumn idCol = new TableColumn(0, 30, cellRenderer, new DefaultCellEditor(new JTextField()));
            idCol.setHeaderValue("#");
            idCol.setResizable(true);
            cm.addColumn(idCol);
            TableColumn[] cols = new TableColumn[dataSheet.getParameterCount() + 1];
            int colIndex = 1;
            while (colIndex <= dataSheet.getParameterCount()) {
                cols[colIndex] = new TableColumn(colIndex, 100, cellRenderer, new DefaultCellEditor(new JTextField()));
                cols[colIndex].setHeaderValue(dataSheet.getParameterName(colIndex - 1));
                cols[colIndex].setResizable(true);
                cm.addColumn(cols[colIndex]);
                ++colIndex;
            }
            this.dataTable.setColumnModel(cm);
        }
    }

    private void log(String message) {
    }

    public JTable getDataTable() {
        return this.dataTable;
    }

    public void setSelectedRows(List<Integer> selection) {
        this.dataTable.clearSelection();
        for (Integer s : selection) {
            this.dataTable.getSelectionModel().addSelectionInterval(s, s);
        }
    }
}

