/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.chart.ScatterChart2D;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.data.Parameter;
import org.xdat.gui.panels.ChartPanel;

public class ScatterChart2DPanel
extends ChartPanel {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;
    private int yAxisOffset = 0;

    public ScatterChart2DPanel(Main mainWindow, ScatterChart2D chart) {
        super(mainWindow.getDataSheet(), chart);
        this.mainWindow = mainWindow;
        this.log("constructor called");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.log("paintComponent called ");
        ScatterChart2D chart = (ScatterChart2D)this.getChart();
        ScatterPlot2D plot = chart.getScatterPlot2D();
        if (chart.getScatterPlot2D().isShowDecorations()) {
            g.setFont(new Font("SansSerif", 0, plot.getTicLabelFontSizeY()));
            this.yAxisOffset = plot.getParameterForYAxis().getLongestTicLabelStringLength(g.getFontMetrics(), "%4.3f");
        }
        if (this.mainWindow.getDataSheet().getParameterCount() > 0) {
            if (!this.mainWindow.getDataSheet().parameterExists(chart.getScatterPlot2D().getParameterForXAxis())) {
                chart.getScatterPlot2D().setParameterForXAxis(this.mainWindow.getDataSheet().getParameter(0));
            }
            if (!this.mainWindow.getDataSheet().parameterExists(chart.getScatterPlot2D().getParameterForYAxis())) {
                chart.getScatterPlot2D().setParameterForYAxis(this.mainWindow.getDataSheet().getParameter(0));
            }
            this.drawDesigns(g, chart);
        }
        if (chart.getScatterPlot2D().isShowDecorations()) {
            this.drawAxes(g, chart, plot);
        }
    }

    public void drawDesigns(Graphics g, ScatterChart2D chart) {
        int delta;
        ScatterPlot2D plot = chart.getScatterPlot2D();
        Parameter paramX = plot.getParameterForXAxis();
        Parameter paramY = plot.getParameterForYAxis();
        if (paramX == null || paramY == null) {
            return;
        }
        DataSheet dataSheet = chart.getDataSheet();
        double[] xValues = new double[dataSheet.getDesignCount()];
        double[] yValues = new double[dataSheet.getDesignCount()];
        double minX = chart.getScatterPlot2D().getMinX();
        double maxX = chart.getScatterPlot2D().getMaxX();
        double minY = chart.getScatterPlot2D().getMinY();
        double maxY = chart.getScatterPlot2D().getMaxY();
        int i = 0;
        while (i < dataSheet.getDesignCount()) {
            xValues[i] = dataSheet.getDesign(i).getDoubleValue(paramX);
            yValues[i] = dataSheet.getDesign(i).getDoubleValue(paramY);
            ++i;
        }
        if (chart.getScatterPlot2D().isAutofitX()) {
            minX = Double.POSITIVE_INFINITY;
            maxX = Double.NEGATIVE_INFINITY;
            i = 0;
            while (i < dataSheet.getDesignCount()) {
                this.log("drawDesigns find xmin: xValues[i]=" + xValues[i]);
                xValues[i] = dataSheet.getDesign(i).getDoubleValue(paramX);
                if (xValues[i] > maxX) {
                    maxX = xValues[i];
                }
                if (xValues[i] < minX) {
                    minX = xValues[i];
                }
                ++i;
            }
            chart.getScatterPlot2D().setMaxX(maxX);
            chart.getScatterPlot2D().setMinX(minX);
        }
        if (chart.getScatterPlot2D().isAutofitY()) {
            minY = Double.POSITIVE_INFINITY;
            maxY = Double.NEGATIVE_INFINITY;
            i = 0;
            while (i < dataSheet.getDesignCount()) {
                yValues[i] = dataSheet.getDesign(i).getDoubleValue(paramY);
                if (yValues[i] > maxY) {
                    maxY = yValues[i];
                }
                if (yValues[i] < minY) {
                    minY = yValues[i];
                }
                ++i;
            }
            chart.getScatterPlot2D().setMaxY(maxY);
            chart.getScatterPlot2D().setMinY(minY);
        }
        double xRange = maxX - minX;
        double yRange = maxY - minY;
        this.log("drawDesigns: maxX=" + maxX);
        this.log("drawDesigns: minX=" + minX);
        this.log("drawDesigns: xRange=" + xRange);
        int plotWidth = chart.getWidth() - chart.getScatterPlot2D().getPlotAreaDistanceToLeft(this.yAxisOffset) - chart.getScatterPlot2D().getPlotAreaDistanceToRight();
        int plotHeight = chart.getHeight() - chart.getScatterPlot2D().getPlotAreaDistanceToTop() - chart.getScatterPlot2D().getPlotAreaDistanceToBottom();
        int xOrig = chart.getScatterPlot2D().getPlotAreaDistanceToLeft(this.yAxisOffset) - chart.getScatterPlot2D().getDotRadius();
        int yOrig = chart.getHeight() - chart.getScatterPlot2D().getPlotAreaDistanceToBottom() - chart.getScatterPlot2D().getDotRadius();
        if (!paramX.isNumeric()) {
            delta = (int)(0.5 * (double)plotWidth / (double)(paramX.getDiscreteLevelCount() + 1));
            plotWidth -= 2 * delta;
            xOrig += delta;
        }
        if (!paramY.isNumeric()) {
            delta = (int)(0.5 * (double)plotHeight / (double)(paramY.getDiscreteLevelCount() + 1));
            plotHeight -= 2 * delta;
            yOrig -= delta;
        }
        int ovalDiameter = 2 * chart.getScatterPlot2D().getDotRadius();
        boolean isXConstant = xRange == 0.0;
        int constantX = (int)((double)xOrig + 0.5 * (double)plotWidth);
        boolean isYConstant = yRange == 0.0;
        int constantY = (int)((double)yOrig - 0.5 * (double)plotHeight);
        switch (chart.getScatterPlot2D().getDisplayedDesignSelectionMode()) {
            case 2: {
                ParallelCoordinatesChart parallelChart = chart.getScatterPlot2D().getParallelCoordinatesChartForFiltering();
                if (chart.getScatterPlot2D().getParallelCoordinatesChartForFiltering() != null) {
                    int i2 = 0;
                    while (i2 < dataSheet.getDesignCount()) {
                        Design design = dataSheet.getDesign(i2);
                        if (dataSheet.getDesign(i2).isActive(parallelChart)) {
                            int x = xOrig + (int)((xValues[i2] - minX) * (double)plotWidth / xRange);
                            int y = yOrig - (int)((yValues[i2] - minY) * (double)plotHeight / yRange);
                            if (isXConstant) {
                                x = constantX;
                            }
                            if (isYConstant) {
                                y = constantY;
                            }
                            if (design.isSelected()) {
                                g.setColor(chart.getScatterPlot2D().getSelectedDesignColor());
                            } else if (design.hasGradientColor()) {
                                g.setColor(parallelChart.getDesignColor(design, true, chart.isUseAlpha()));
                            } else {
                                g.setColor(chart.getScatterPlot2D().getDesignColor(design));
                            }
                            g.fillOval(x, y, ovalDiameter, ovalDiameter);
                        }
                        ++i2;
                    }
                    break;
                }
            }
            case 0: {
                int i3 = 0;
                while (i3 < dataSheet.getDesignCount()) {
                    int x = xOrig + (int)((xValues[i3] - minX) * (double)plotWidth / xRange);
                    int y = yOrig - (int)((yValues[i3] - minY) * (double)plotHeight / yRange);
                    if (isXConstant) {
                        x = constantX;
                    }
                    if (isYConstant) {
                        y = constantY;
                    }
                    g.setColor(chart.getScatterPlot2D().getDesignColor(dataSheet.getDesign(i3)));
                    if (dataSheet.getDesign(i3).isSelected()) {
                        g.setColor(chart.getScatterPlot2D().getSelectedDesignColor());
                    } else {
                        g.setColor(chart.getScatterPlot2D().getDesignColor(dataSheet.getDesign(i3)));
                    }
                    g.fillOval(x, y, ovalDiameter, ovalDiameter);
                    ++i3;
                }
                break;
            }
            case 1: {
                int i4 = 0;
                while (i4 < dataSheet.getDesignCount()) {
                    if (dataSheet.getDesign(i4).isSelected()) {
                        int x = xOrig + (int)((xValues[i4] - minX) * (double)plotWidth / xRange);
                        int y = yOrig - (int)((yValues[i4] - minY) * (double)plotHeight / yRange);
                        if (isXConstant) {
                            x = constantX;
                        }
                        if (isYConstant) {
                            y = constantY;
                        }
                        g.setColor(chart.getScatterPlot2D().getDesignColor(dataSheet.getDesign(i4)));
                        g.fillOval(x, y, ovalDiameter, ovalDiameter);
                    }
                    ++i4;
                }
                break;
            }
        }
    }

    public void drawAxes(Graphics g, ScatterChart2D chart, ScatterPlot2D plot) {
        this.log("drawAxes: chart height: " + chart.getHeight());
        this.log("drawAxes: chart width: " + chart.getWidth());
        g.setColor(chart.getBackGroundColor());
        g.fillRect(0, 0, chart.getWidth(), plot.getPlotAreaDistanceToTop());
        g.fillRect(0, 0, plot.getPlotAreaDistanceToLeft(this.yAxisOffset), chart.getHeight());
        g.fillRect(0, chart.getHeight() - plot.getPlotAreaDistanceToBottom(), chart.getWidth(), chart.getHeight());
        g.fillRect(chart.getWidth() - plot.getPlotAreaDistanceToRight(), 0, plot.getPlotAreaDistanceToRight(), chart.getHeight());
        g.setColor(plot.getDecorationsColor());
        int x1 = plot.getPlotAreaDistanceToLeft(this.yAxisOffset);
        int y1 = chart.getHeight() - plot.getPlotAreaDistanceToBottom();
        int x2 = plot.getPlotAreaDistanceToLeft(this.yAxisOffset);
        int y2 = plot.getPlotAreaDistanceToTop();
        g.drawLine(x1, y1, x2, y2);
        if (!plot.getParameterForYAxis().isNumeric()) {
            int delta = (int)(0.5 * (double)(y1 - y2) / (double)(plot.getParameterForYAxis().getDiscreteLevelCount() + 1));
            y1 -= delta;
            y2 += delta;
        }
        int ticCountY = plot.getParameterForYAxis().isNumeric() ? (plot.getMinY() == plot.getMaxY() ? 1 : plot.getTicCountY()) : plot.getParameterForYAxis().getDiscreteLevelCount();
        g.setFont(new Font("SansSerif", 0, plot.getTicLabelFontSizeY()));
        if (ticCountY == 1) {
            int y = (int)(0.5 * (double)(y2 + y1));
            g.drawLine(x2, (int)(0.5 * (double)(y2 + y1)), x2 + plot.getTicSize(), y);
            String label = this.getTicLabelY(plot, 0);
            int xOffset = g.getFontMetrics().stringWidth(label);
            g.drawString(label, x2 - xOffset - 10, y + (int)(0.5 * (double)plot.getTicLabelFontSizeY()));
        } else {
            int ticSpacingY = (int)((float)(y1 - y2) / (float)(ticCountY - 1));
            int i = 0;
            while (i < ticCountY) {
                int ticY = y1 - i * ticSpacingY;
                g.drawLine(x2, ticY, x2 + plot.getTicSize(), ticY);
                String label = this.getTicLabelY(plot, i);
                int xOffset = g.getFontMetrics().stringWidth(label);
                g.drawString(label, x2 - xOffset - 10, ticY + (int)(0.5 * (double)plot.getTicLabelFontSizeY()));
                ++i;
            }
        }
        x1 = plot.getPlotAreaDistanceToLeft(this.yAxisOffset);
        y1 = chart.getHeight() - plot.getPlotAreaDistanceToBottom();
        x2 = chart.getWidth() - plot.getPlotAreaDistanceToRight();
        y2 = chart.getHeight() - plot.getPlotAreaDistanceToBottom();
        g.drawLine(x1, y1, x2, y2);
        if (!plot.getParameterForXAxis().isNumeric()) {
            int delta = (int)(0.5 * (double)(x2 - x1) / (double)(plot.getParameterForXAxis().getDiscreteLevelCount() + 1));
            x1 += delta;
            x2 -= delta;
        }
        int ticCountX = plot.getParameterForXAxis().isNumeric() ? (plot.getMinX() == plot.getMaxX() ? 1 : plot.getTicCountX()) : plot.getParameterForXAxis().getDiscreteLevelCount();
        g.setFont(new Font("SansSerif", 0, plot.getTicLabelFontSizeX()));
        if (ticCountX == 1) {
            int x = (int)(0.5 * (double)(x1 + x2));
            g.drawLine(x, y2, x, y2 - plot.getTicSize());
            String label = this.getTicLabelX(plot, 0);
            int xOffset = (int)(0.5 * (double)g.getFontMetrics().stringWidth(label));
            g.drawString(label, x - xOffset, y2 + 10 + plot.getTicLabelFontSizeX());
        } else {
            int ticSpacingX = (int)((float)(x2 - x1) / (float)(ticCountX - 1));
            int i = 0;
            while (i < ticCountX) {
                int ticX = x1 + i * ticSpacingX;
                g.drawLine(ticX, y2, ticX, y2 - plot.getTicSize());
                String label = this.getTicLabelX(plot, i);
                int xOffset = (int)(0.5 * (double)g.getFontMetrics().stringWidth(label));
                g.drawString(label, ticX - xOffset, y2 + 10 + plot.getTicLabelFontSizeX());
                ++i;
            }
        }
        String xParameterName = "";
        if (plot.getParameterForXAxis() != null) {
            xParameterName = plot.getParameterForXAxis().getName();
        }
        g.setFont(new Font("SansSerif", 0, plot.getAxisLabelFontSizeX()));
        int slenX = g.getFontMetrics().stringWidth(xParameterName);
        g.drawString(xParameterName, (chart.getWidth() - slenX) / 2, chart.getHeight() - plot.getMargin() - 10);
        String yParameterName = "";
        if (plot.getParameterForYAxis() != null) {
            yParameterName = plot.getParameterForYAxis().getName();
        }
        g.setFont(new Font("SansSerif", 0, plot.getAxisLabelFontSizeY()));
        int slenY = g.getFontMetrics().stringWidth(yParameterName);
        Graphics2D g2D = (Graphics2D)g;
        AffineTransform fontAT = new AffineTransform();
        Font origFont = g2D.getFont();
        fontAT.rotate(-1.5707963267948966);
        Font theDerivedFont = origFont.deriveFont(fontAT);
        g2D.setFont(theDerivedFont);
        g2D.drawString(yParameterName, plot.getMargin() + 10 + plot.getAxisLabelFontSizeY(), (chart.getHeight() + slenY) / 2);
        g2D.setFont(origFont);
    }

    private String getTicLabelX(ScatterPlot2D plot, int ticIndex) {
        double value = plot.getMinX() + (double)ticIndex * (plot.getMaxX() - plot.getMinX()) / (double)(plot.getTicCountX() - 1);
        if (plot.getParameterForXAxis().isNumeric()) {
            return String.format("%4.3f", value);
        }
        return plot.getParameterForXAxis().getStringValueOf(ticIndex);
    }

    private String getTicLabelY(ScatterPlot2D plot, int ticIndex) {
        double value = plot.getMinY() + (double)ticIndex * (plot.getMaxY() - plot.getMinY()) / (double)(plot.getTicCountY() - 1);
        if (plot.getParameterForYAxis().isNumeric()) {
            return String.format("%4.3f", value);
        }
        return plot.getParameterForYAxis().getStringValueOf(ticIndex);
    }

    private void log(String message) {
    }
}

