/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.workerThreads;

import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.xdat.Main;
import org.xdat.data.DataSheet;

public class DataSheetCreationThread
extends SwingWorker {
    static final boolean printLog = false;
    private String pathToInputFile;
    private boolean dataHasHeaders;
    private Main mainWindow;
    private ProgressMonitor progressMonitor;

    public DataSheetCreationThread(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) {
        this.pathToInputFile = pathToInputFile;
        this.dataHasHeaders = dataHasHeaders;
        this.mainWindow = mainWindow;
        this.progressMonitor = progressMonitor;
    }

    public Object doInBackground() {
        this.log("do in background invoked from Thread " + Thread.currentThread().getId());
        try {
            DataSheet dataSheet = new DataSheet(this.pathToInputFile, this.dataHasHeaders, this.mainWindow, this.progressMonitor);
            this.log("do in background: data sheet created.");
            if (this.progressMonitor.isCanceled()) {
                this.log("do in background: progress monitor is cancelled.");
                this.mainWindow.repaint();
            } else {
                this.log("do in background: progress monitor is completed.");
                this.mainWindow.setDataSheet(dataSheet);
                this.mainWindow.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n " + e.getMessage(), "Import Data", 0);
        }
        this.progressMonitor.close();
        return null;
    }

    private void log(String message) {
    }
}

